using System;
using System.Collections.Generic;
using System.Linq;

class Program
{
  
    static void Main()
    {
        int n = int.Parse(Console.ReadLine());
        int[] x = new int[n];
        int[] y = new int[n];

        for (int i = 0; i < n; i++)
        {
            string[] s = Console.ReadLine().Split();
            x[i] = int.Parse(s[0]);
            y[i] = int.Parse(s[1]);

        }
        int[] p = new int[n-1];
        int sum = 0;

        for(int i = 0; i < n-1; i++)
        {
            if ((x[i] - x[i + 1]) % 2 == 0) p[i] =1;
            else p[i] = 0;
        }

        // Implementacija prefiksnih suma za O(1) sumiranje opsega
        int[] prefixSums = new int[n]; // Niz velicine n (jer p ima n-1 elemenata)
        prefixSums[0] = 0;
        for (int i = 0; i < n - 1; i++)
        {
            prefixSums[i + 1] = prefixSums[i] + p[i];
        }

        long totalSum = 0; // Koristimo long za ukupnu sumu, ako je velika

        // Prvi deo sume (suma svih pojedinacnih elemenata u p)
        // To je ujedno i ukupan broj jedinica u nizu p, što je prefixSums[n-1]
        totalSum += prefixSums[n - 1];

        // Optimizovane ugnezdene petlje
        for (int j = 1; j < n - 1; j++)
        {
            for (int i = 0; i < n - 1 - j; i++) // Ispravljen uslov petlje
            {
                // p[(int)(i + j)] -> p[i+j]
                // p.Skip((int)i).Take((int)(j - i + 1)).Sum() -> O(1) sa prefixSums

                // SumInRange(start, end) = prefixSums[end + 1] - prefixSums[start]
                // Ovde je opseg od i do i+j. 
                // SumInRange(i, i+j) = prefixSums[i + j + 1] - prefixSums[i]

                int rangeSum = prefixSums[i + j + 1] - prefixSums[i];

                // Uslov iz originalnog koda
                if (p[i + j] == rangeSum)
                {
                    totalSum += 1;
                }
            }
        }
        Console.WriteLine(totalSum);        

    }
}